package com.elitescloud.cloudt.system.service.model.entity;

import cn.hutool.json.JSONObject;
import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.constant.OrgType;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Formula;

import javax.persistence.*;
import java.util.Map;

/**
 * 组织.
 * <p>
 * 系统中的一大主数据
 *
 * @author Kaiser（wang shao）
 * 2022/9/15
 */
@Entity
@Table(name = "sys_org", indexes = {
        @Index(name = "idx_org_outer_code", columnList = "outerCode"),
        @Index(name = "idx_org_code", columnList = "code"),
        @Index(name = "idx_org_parent_code", columnList = "parentCode"),
        @Index(name = "idx_org_parent_type", columnList = "type"),
        @Index(name = "idx_org_pid", columnList = "pId"),
        @Index(name = "idx_org_rootid", columnList = "rootId"),
        @Index(name = "idx_org_lft", columnList = "lft"),
        @Index(name = "idx_org_rgt", columnList = "rgt"),
})
@Comment("组织")
@Getter
@Setter
public class SysOrgDO extends BaseTreeModel {
    private static final long serialVersionUID = 7990519018447056463L;

    @Column()
    @Comment("上级组织编码")
    private String parentCode;

    @Column()
    @Comment(value = "是否行政组织", defaultValue = "1")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean executive;

    @Column(nullable = false)
    @Comment("组织编码")
    private String code;

    @Column()
    @Comment("外部组织编码")
    private String outerCode;

    @Column(nullable = false)
    @Comment("组织名称")
    private String name;

    @Column()
    @Comment("简称")
    private String shortName;

    @Column()
    @Comment("英语名称")
    private String englishName;

    /**
     * {@link com.elitescloud.cloudt.system.constant.OrgType}
     */
    @Column()
    @Comment("类型，[UDC]cloudt-system:orgType")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true
            , relatedBusinessObject = BusinessObjectConstant.SYS_PLATFORM_UDC, relatedField = "udcValueCode",
            values = {Application.NAME, OrgType.UDC_CODE})
    private String type;

    @Column()
    @Comment(value = "是否是实体组织", defaultValue = "1")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean entity;

    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean enabled;

    @Column()
    @Comment(value = "所属公司ID")
    private Long ouId;

    /**
     * {@link com.elitescloud.cloudt.constant.SysRegion}
     */
    @Column()
    @Comment(value = "区域，[UDC]cloudt-system:region")
    private String region;

    /**
     * {@link com.elitescloud.cloudt.constant.SysBusinessUnit}
     */
    @Column()
    @Comment(value = "事业部，[UDC]cloudt-system:businessUnit")
    private String businessUnit;

    /**
     * {@link com.elitescloud.cloudt.constant.SysProfitablyCenter}
     */
    @Column()
    @Comment(value = "利润中心，[UDC]cloudt-system:profitablyCenter")
    private String profitablyCenter;

    /**
     * {@link com.elitescloud.cloudt.constant.SysFunctionType}
     */
    @Column()
    @Comment(value = "职能类型，[UDC]cloudt-system:functionType")
    private String functionType;

    @Column()
    @Comment(value = "是否向外同步", defaultValue = "1")
    private Boolean syncOuter;

    @Column(name = "lang_json")
    @Comment(value = "多语言")
    private String langJson;

//    @Formula("json_extract(langJson, '$.zh_CN.name')")
    @Transient
    private String nameLocale;

    public String getPrettyName() {
        if (shortName == null || shortName.trim().isEmpty()) {
            return name;
        }
        return shortName;
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysOrgDO) {
            SysOrgDO the = (SysOrgDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
