package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 角色组.
 * <p>
 * 角色的分组
 * @author Kaiser（wang shao）
 * @date 2023/11/24
 */
@Entity
@Table(name = "sys_role_group", indexes = {
        @Index(name = "idx_role_group_type", columnList = "type"),
        @Index(name = "idx_role_group_typeid", columnList = "typeId"),
})
@Comment("角色分组")
@Getter
@Setter
public class SysRoleGroupDO extends BaseModel {
    private static final long serialVersionUID = 6089790548840359464L;

    @Column()
    @Comment(value = "分组编码")
    private String groupCode;

    @Column(nullable = false)
    @Comment(value = "分组名称")
    private String groupName;

    @Column()
    @Comment(value = "启用状态", defaultValue = "1")
    private Boolean enabled;

    @Column()
    @Comment(value = "描述")
    private String description;

    /**
     * 角色归属类型
     * {@link BelongType}
     */
    @Column()
    @Comment(value = "角色类型")
    private String type;

    @Column()
    @Comment(value = "类型标识")
    private String typeId;
}
