package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 角色与权限的关联.
 *
 * @author Kaiser（wang shao）
 * 2022/9/15
 */
@Entity
@Table(name = "sys_role_permission", indexes = {
        @Index(name = "idx_role_perm_role_id", columnList = "roleId"),
        @Index(name = "idx_role_perm_perm_code", columnList = "permissionCode"),
        @Index(name = "idx_role_perm_perm_type", columnList = "permissionType"),
        @Index(name = "idx_role_perm_perm_app", columnList = "appCode"),
})
@Comment("角色权限关联")
@Getter
@Setter
@Accessors(chain = true)
public class SysRolePermissionDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 6809202611911165338L;

    @Column(nullable = false)
    @Comment("角色ID")
    private Long roleId;

    @Column()
    @Comment("角色编码")
    private String roleCode;

    @Column(nullable = false)
    @Comment("权限编码")
    private String permissionCode;

    @Column()
    @Comment("应用编码")
    private String appCode;

    /**
     * {@link MenuTreeNodeType}
     */
    @Column(nullable = false)
    @Comment("权限类型")
    private String permissionType;

    @Column
    @Comment(value = "是否自定义权限树", defaultValue = "0")
    private Boolean custom;

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysRolePermissionDO) {
            SysRolePermissionDO the = (SysRolePermissionDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}