package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 系统子账号.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/27
 */
@Entity
@Table(name = "sys_sub_user", indexes = {
        @Index(name = "idx_sub_user_user", columnList = "typeId"),
        @Index(name = "idx_sub_user_subuser", columnList = "subUserId"),
})
@Comment("系统子账号")
@DynamicInsert
@Getter
@Setter
public class SysSubUserDO extends BaseModel {
    private static final long serialVersionUID = 889771997896160946L;

    @Comment("子账号ID")
    @Column(nullable = false)
    private Long subUserId;

    /**
     * 归属类型
     * {@link BelongType}
     */
    @Column()
    @Comment(value = "归属类型")
    private String type;

    @Column()
    @Comment(value = "归属类型标识")
    private String typeId;

    /**
     * 权限类型
     * <p>
     * {@link com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum}
     */
    @Column()
    @Comment(value = "权限类型")
    private String permissionType;
}
