package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.system.constant.TenantType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <p>
 * 租户实体类
 * <p>
 *
 * @author Roman.Zhang
 * 2022/2/15
 */
@Entity
@Table(name = "sys_tenant", indexes = {
        @Index(name = "idx_sys_tenant_code", columnList = "tenantCode")
})
@Comment("平台租户表")
@Getter
@Setter
@ToString
@Accessors(chain = true)
@DynamicUpdate
public class SysTenantDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8488424485195763878L;

    @Comment("租户编码")
    @Column(nullable = false)
    private String tenantCode;

    @Comment("租户名称")
    @Column(nullable = false)
    private String tenantName;

    @Comment("管理员用户ID")
    @Column(nullable = false)
    private Long sysUserId;

    @Comment("管理员登录账号")
    @Column(nullable = false)
    private String adminAccount;

    /**
     * {@link TenantType}
     */
    @Comment("租户类型")
    @Column()
    private String tenantType;

    @Comment(value = "是否启用", defaultValue = "0")
    @Column()
    private Boolean enabled;

    @Comment("联系人")
    @Column()
    private String linkman;

    @Comment("联系电话")
    @Column()
    private String contactNumber;

    @Comment("联系地址")
    @Column()
    private String address;

    /**
     * 租户数据隔离方法
     * {@link TenantIsolateStrategy}
     */
    @Comment("租户数据隔离策略")
    @Column()
    private String tenantIsolation;

    @Comment(value = "数据库是否已初始化", defaultValue = "0")
    @Column()
    private Boolean dbInitialized;

    @Comment(value = "基础数据同步记录ID")
    @Column()
    private Long baseDataSyncId;

    @Comment("schema名称")
    @Column()
    private String schemaName;

    @Comment("域名地址，二级域名部分")
    @Column()
    private String tenantDomain;

    @Comment("用户自己的域名")
    @Column()
    private String customDomain;

    @Comment(value = "所属行业，[UDC]COM:INDUSTRY")
    @Column()
    private String industry;

    @Comment(value = "所属客户，[UDC]SYS:CUSTOMER")
    @Column()
    private String customer;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysTenantDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysTenantDO entity = (SysTenantDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
