package com.elitescloud.cloudt.system.service.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 用户绑定的租户.
 *
 * @author Kaiser（wang shao）
 * 2022/3/23
 */
@Data
@ApiModel(description = "用户租户信息")
public class SysUserTenantVO implements Serializable {
    private static final long serialVersionUID = -8131848188770026539L;

    /**
     * 用户ID
     */
    @ApiModelProperty("用户ID")
    private Long sysUserId;

    /**
     * 租户的唯一标识
     */
    @ApiModelProperty("租户的唯一标识")
    private Long sysTenantId;

    /**
     * 绑定时间
     */
    @ApiModelProperty("绑定时间")
    private LocalDateTime bindTime;

    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private String tenantCode;

    /**
     * 租户名称
     */
    @ApiModelProperty("租户名称")
    private String tenantName;

    /**
     * 租户域名
     */
    @ApiModelProperty("租户域名")
    private String tenantDomain;

    /**
     * 自定义域名
     */
    @ApiModelProperty("自定义域名")
    private String customDomain;
}
