package com.elitescloud.cloudt.system.service.old;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.param.SysUserQueryParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;

import java.util.List;
import java.util.Set;

/**
 * <pre>
 * 系统用户操作逻辑服务类
 * </pre>
 *
 * @author Michael Li
 * 2020/6/16
 */
@Deprecated
public interface ISysUserService {

    /**
     * 根据查询条件检索用户信息
     *
     * @param param 查询条件对象
     * @return 用户信息集合
     */
    @Deprecated
    PagingVO<SysUserVO> search(SysUserQueryParam param);

    /**
     * 根据用户id获取用户详情VO
     *
     * @param id id
     * @return 详情
     */
    @Deprecated
    SysUserDetailsVO findDetailsById(Long id);

    /**
     * @param id
     * @return
     */
    SysUserDTO getById(Long id);

    List<SysUserVO> getByIds(List<Long> ids);

    /**
     * 根据用户账号查询用户信息
     * <p>
     * 主要用于登录
     *
     * @param username 用户账号
     * @return 用户信息
     */
    SysUserDTO getUserByUsername(String username);

    /**
     * 根据手机号查询用户信息
     * <p>
     * 主要用于登录
     *
     * @param mobile 手机号
     * @return 用户信息
     */
    SysUserDTO getUserByMobile(String mobile);

    /**
     * 根据邮箱查询用户信息
     * <p>
     * 主要用于登录
     *
     * @param email 邮箱
     * @return 用户信息
     */
    SysUserDTO getUserByEmail(String email);

    /**
     * 根据用户ID查询用户信息
     * <p>
     * 主要用于登录
     *
     * @param id 用户ID
     * @return 用户信息
     */
    SysUserDTO getUserById(Long id);

    /**
     * 根据账号查询用户信息
     * <p>
     * 主要用于登录
     *
     * @param account 账号
     * @return 用户信息
     */
    SysUserDTO getUserByAccount(String account);

    /**
     * 根据手机号查询用户信息
     * <p>
     * 主要用于登录
     *
     * @param wechatOpenid 微信openid
     * @return 用户信息
     */
    SysUserDTO getUserByWechatOpenid(String wechatOpenid);

    /**
     * 根据用户名获取用户ID
     *
     * @param username 用户名
     * @return 用户ID
     */
    Long getUserIdByUsername(String username);

    /**
     * 创建新用户
     *
     * @param user     用户账号信息
     * @param password 自定义密码
     * @return 新用户账号ID
     */
    Long create(SysUserNewParam user, String password);

    /**
     * 更新用户
     *
     * @param user 更新信息
     * @return id
     */
    Long update(SysUserUpdateParam user);

    Boolean switchUserStatus(Long id);

    /**
     * 更新用户绑定的微信id
     *
     * @param userName 用户登录号
     * @param openid   微信id
     * @return 用户登录号
     */
    ApiResult<String> updateUserWechatOpenid(String userName, String openid);

    /**
     * 用户 批量启用/禁用
     *
     * @param param 参数
     */
    void batchSwitchUserStatus(SysUserBatchSwitchParam param);

    Set<SysRoleVO> listRolesByUsername(String username);

    SysUserDTO current();

    void deleteBatch(List<Long> idList);

    /**
     * 查询用户信息
     *
     * @param param 查询条件
     * @return dto
     */
    List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param);
}
