package com.elitescloud.cloudt.system.config;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.constant.AccountType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.time.Duration;
import java.util.*;

/**
 * 系统配置属性.
 *
 * @author Kaiser（wang shao）
 * 2022/7/6
 */
@ConfigurationProperties(prefix = SystemProperties.CONFIG_PREFIX)
public class SystemProperties {

    public static final String CONFIG_PREFIX = "elitesland.project.system";

    /**
     * 登录账号是否可修改
     */
    private Boolean usernameEditable = false;

    /**
     * 组织编号是否可变更
     */
    private Boolean orgCodeEditable = false;

    /**
     * 是否限制手机号唯一
     */
    private Boolean mobileUnique = true;

    /**
     * 是否限制邮箱唯一
     */
    private Boolean emailUnique = true;

    /**
     * 是否限制证件号唯一
     */
    private Boolean idCardUnique = true;

    /**
     * 账号类型
     * <p>
     * 用于指明登录时所匹配的账号类型
     */
    private List<AccountType> accountTypes = new ArrayList<>(4);

    /**
     * 权限配置冲突时是否显示
     */
    private Boolean permissionConflictShow = true;

    /**
     * 是否限制组织树只能有一个
     */
    private Boolean limitOrgTreeOne = true;

    /**
     * 是否使用公司类型的组织作为ou
     */
    private Boolean useCompanyOrgAsOu = true;

    /**
     * 业务对象的公共资源
     */
    private Set<String> businessObjectPublicResources = null;

    /**
     * 自定义的内置业务对象
     */
    private Set<String> businessObjectInnerCustom = new HashSet<>(0);

    /**
     * 默认的用户类型角色
     * <p>
     * 创建账户时，自动为其绑定的角色
     */
    private Map<String, CodeNameParam> defaultUserTypeRole = new HashMap<>();

    /**
     * 行政区域
     */
    @NestedConfigurationProperty
    private Area area = new Area();

    /**
     * 三方接口日志
     */
    @NestedConfigurationProperty
    private ThirdApiLog thirdApiLog = new ThirdApiLog();

    /**
     * 标产版本
     */
    @NestedConfigurationProperty
    private StdProject stdProject = new StdProject();

    /**
     * 统一查询
     */
    @NestedConfigurationProperty
    private UnifyQuery unifyQuery = new UnifyQuery();

    /**
     * 帆软报表配置
     */
    @NestedConfigurationProperty
    private FineReport fineReport = new FineReport();

    /**
     * JDE配置
     */
    @NestedConfigurationProperty
    private JdeConfig jdeConfig = new JdeConfig();

    /**
     * 星云座配置
     */
    @NestedConfigurationProperty
    private XingYunZuo xingYunZuo = new XingYunZuo();

    /**
     * 企微认证
     */
    private WecomAuth wecomAuth = new WecomAuth();

    public Area getArea() {
        return area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public Boolean getUsernameEditable() {
        return usernameEditable;
    }

    public void setUsernameEditable(Boolean usernameEditable) {
        this.usernameEditable = usernameEditable;
    }

    public Boolean getOrgCodeEditable() {
        return orgCodeEditable;
    }

    public void setOrgCodeEditable(Boolean orgCodeEditable) {
        this.orgCodeEditable = orgCodeEditable;
    }

    public Boolean getMobileUnique() {
        return mobileUnique;
    }

    public void setMobileUnique(Boolean mobileUnique) {
        this.mobileUnique = mobileUnique;
    }

    public Boolean getEmailUnique() {
        return emailUnique;
    }

    public void setEmailUnique(Boolean emailUnique) {
        this.emailUnique = emailUnique;
    }

    public Boolean getIdCardUnique() {
        return idCardUnique;
    }

    public void setIdCardUnique(Boolean idCardUnique) {
        this.idCardUnique = idCardUnique;
    }

    public List<AccountType> getAccountTypes() {
        return accountTypes;
    }

    public void setAccountTypes(List<AccountType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public Boolean getPermissionConflictShow() {
        return permissionConflictShow;
    }

    public void setPermissionConflictShow(Boolean permissionConflictShow) {
        this.permissionConflictShow = permissionConflictShow;
    }

    public Boolean getLimitOrgTreeOne() {
        return limitOrgTreeOne;
    }

    public void setLimitOrgTreeOne(Boolean limitOrgTreeOne) {
        this.limitOrgTreeOne = limitOrgTreeOne;
    }

    public Boolean getUseCompanyOrgAsOu() {
        return useCompanyOrgAsOu;
    }

    public void setUseCompanyOrgAsOu(Boolean useCompanyOrgAsOu) {
        this.useCompanyOrgAsOu = useCompanyOrgAsOu;
    }

    public Set<String> getBusinessObjectPublicResources() {
        return businessObjectPublicResources;
    }

    public void setBusinessObjectPublicResources(Set<String> businessObjectPublicResources) {
        this.businessObjectPublicResources = businessObjectPublicResources;
    }

    public Set<String> getBusinessObjectInnerCustom() {
        return businessObjectInnerCustom;
    }

    public void setBusinessObjectInnerCustom(Set<String> businessObjectInnerCustom) {
        this.businessObjectInnerCustom = businessObjectInnerCustom;
    }

    public Map<String, CodeNameParam> getDefaultUserTypeRole() {
        return defaultUserTypeRole;
    }

    public void setDefaultUserTypeRole(Map<String, CodeNameParam> defaultUserTypeRole) {
        this.defaultUserTypeRole = defaultUserTypeRole;
    }

    public ThirdApiLog getThirdApiLog() {
        return thirdApiLog;
    }

    public void setThirdApiLog(ThirdApiLog thirdApiLog) {
        this.thirdApiLog = thirdApiLog;
    }

    public StdProject getStdProject() {
        return stdProject;
    }

    public void setStdProject(StdProject stdProject) {
        this.stdProject = stdProject;
    }

    public UnifyQuery getUnifyQuery() {
        return unifyQuery;
    }

    public void setUnifyQuery(UnifyQuery unifyQuery) {
        this.unifyQuery = unifyQuery;
    }

    public FineReport getFineReport() {
        return fineReport;
    }

    public void setFineReport(FineReport fineReport) {
        this.fineReport = fineReport;
    }

    public JdeConfig getJdeConfig() {
        return jdeConfig;
    }

    public void setJdeConfig(JdeConfig jdeConfig) {
        this.jdeConfig = jdeConfig;
    }

    public XingYunZuo getXingYunZuo() {
        return xingYunZuo;
    }

    public void setXingYunZuo(XingYunZuo xingYunZuo) {
        this.xingYunZuo = xingYunZuo;
    }

    public WecomAuth getWecomAuth() {
        return wecomAuth;
    }

    public void setWecomAuth(WecomAuth wecomAuth) {
        this.wecomAuth = wecomAuth;
    }

    public static class ThirdApiLog {
        /**
         * 是否启用重试
         */
        private Boolean enabledRetry = false;

        /**
         * 重试次数
         */
        private Integer retryTimes = 3;

        /**
         * 重试间隔
         */
        private List<Duration> retryIntervals = List.of(Duration.ofMinutes(10), Duration.ofMinutes(20), Duration.ofMinutes(30));

        /**
         * 业务类型
         */
        private List<CodeNameParam> businessTypes = new ArrayList<>();

        /**
         * 源系统
         */
        private List<CodeNameParam> sourceSystems = new ArrayList<>();

        /**
         * 目标系统
         */
        private List<CodeNameParam> targetSystems = new ArrayList<>();
        /**
         * 聚合查询时默认显示天数
         */
        private Integer aggDefaultDays = 1;

        /**
         * 日志保留天数
         * <p>
         * 小于0时表示永久
         */
        private Integer logKeepDays = 30;

        public Boolean getEnabledRetry() {
            return enabledRetry;
        }

        public void setEnabledRetry(Boolean enabledRetry) {
            this.enabledRetry = enabledRetry;
        }

        public Integer getRetryTimes() {
            return retryTimes;
        }

        public void setRetryTimes(Integer retryTimes) {
            this.retryTimes = retryTimes;
        }

        public List<Duration> getRetryIntervals() {
            return retryIntervals;
        }

        public void setRetryIntervals(List<Duration> retryIntervals) {
            this.retryIntervals = retryIntervals;
        }

        public List<CodeNameParam> getBusinessTypes() {
            return businessTypes;
        }

        public void setBusinessTypes(List<CodeNameParam> businessTypes) {
            this.businessTypes = businessTypes;
        }

        public List<CodeNameParam> getSourceSystems() {
            return sourceSystems;
        }

        public void setSourceSystems(List<CodeNameParam> sourceSystems) {
            this.sourceSystems = sourceSystems;
        }

        public List<CodeNameParam> getTargetSystems() {
            return targetSystems;
        }

        public void setTargetSystems(List<CodeNameParam> targetSystems) {
            this.targetSystems = targetSystems;
        }

        public Integer getAggDefaultDays() {
            return aggDefaultDays;
        }

        public void setAggDefaultDays(Integer aggDefaultDays) {
            this.aggDefaultDays = aggDefaultDays;
        }

        public Integer getLogKeepDays() {
            return logKeepDays;
        }

        public void setLogKeepDays(Integer logKeepDays) {
            this.logKeepDays = logKeepDays;
        }
    }

    public static class StdProject {
        /**
         * 是否标产
         */
        private Boolean enabled = false;
        /**
         * 租户编码
         */
        private String tenantCode = "";

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getTenantCode() {
            return tenantCode;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }
    }

    public static class UnifyQuery {
        /**
         * 是否保存查询结果
         */
        private Boolean saveQueryResult = false;

        public Boolean getSaveQueryResult() {
            return saveQueryResult;
        }

        public void setSaveQueryResult(Boolean saveQueryResult) {
            this.saveQueryResult = saveQueryResult;
        }
    }

    public static class FineReport {

        /**
         * 服务端地址
         */
        private String serverAddr;

        /**
         * 公钥信息
         */
        private String publicKey;

        /**
         * 生成token时是否携带颁发时间
         */
        private Boolean tokenWithIssueTime = true;

        /**
         * 默认报表路径
         */
        private String defaultViewlet;

        /**
         * 账户类型
         */
        private AccountType accountType = AccountType.USERNAME;

        public String getServerAddr() {
            return serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getPublicKey() {
            return publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public Boolean getTokenWithIssueTime() {
            return tokenWithIssueTime;
        }

        public void setTokenWithIssueTime(Boolean tokenWithIssueTime) {
            this.tokenWithIssueTime = tokenWithIssueTime;
        }

        public String getDefaultViewlet() {
            return defaultViewlet;
        }

        public void setDefaultViewlet(String defaultViewlet) {
            this.defaultViewlet = defaultViewlet;
        }

        public AccountType getAccountType() {
            return accountType;
        }

        public void setAccountType(AccountType accountType) {
            this.accountType = accountType;
        }
    }

    public static class JdeConfig {
        /**
         * 系统名称
         */
        private String sysName = "ERP";

        /**
         * 服务地址
         */
        private String serverAddr;

        /**
         * 客户端ID
         */
        private String clientId;

        /**
         * 客户端密码
         */
        private String clientSecret;

        public String getSysName() {
            return sysName;
        }

        public void setSysName(String sysName) {
            this.sysName = sysName;
        }

        public String getServerAddr() {
            return serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }
    }

    public static class XingYunZuo {

        /**
         * 秘钥
         * <p>
         * hs256
         */
        private String secretKey = "dS5NS/dWFdo4LAbeDeaGTfr2Kd5zma+0ln3/shQcIEA=";

        /**
         * 有效时间，默认1小时
         */
        private Duration ttl = Duration.ofHours(1);

        /**
         * 商户ID
         */
        private String merchantId = "1";

        /**
         * 项目ID
         */
        private String projectId = "318";

        public String getSecretKey() {
            return secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public Duration getTtl() {
            return ttl;
        }

        public void setTtl(Duration ttl) {
            this.ttl = ttl;
        }

        public String getMerchantId() {
            return merchantId;
        }

        public void setMerchantId(String merchantId) {
            this.merchantId = merchantId;
        }

        public String getProjectId() {
            return projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }
    }

    public static class WecomAuth {

        /**
         * 认证地址
         */
        private String authUrl = "https://login.work.weixin.qq.com/wwlogin/sso/login";

        /**
         * 企业ID
         */
        private String appId;

        /**
         * 应用ID
         */
        private String agentId;

        /**
         * 应用秘钥
         */
        private String agentSecret;

        /**
         * 登录类型
         */
        private String loginType = "CorpApp";

        public String getAuthUrl() {
            return authUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAgentId() {
            return agentId;
        }

        public void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public String getAgentSecret() {
            return agentSecret;
        }

        public void setAgentSecret(String agentSecret) {
            this.agentSecret = agentSecret;
        }

        public String getLoginType() {
            return loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }
    }

    public static class Area {
        /**
         * 中国的编码
         */
        private String chinaCode = "CN";

        /**
         * 强制抓取层级
         * <p>
         * 即省、市、县，没有则补全
         */
        private Boolean forceLevel = true;

        /**
         * 抓取行政区域编码的地址
         */
        private String grabAreaUrl = "https://www.mca.gov.cn/mzsj/xzqh/2025/202401xzqh.html";

        public String getChinaCode() {
            return chinaCode;
        }

        public void setChinaCode(String chinaCode) {
            this.chinaCode = chinaCode;
        }

        public String getGrabAreaUrl() {
            return grabAreaUrl;
        }

        public void setGrabAreaUrl(String grabAreaUrl) {
            this.grabAreaUrl = grabAreaUrl;
        }

        public Boolean getForceLevel() {
            return forceLevel;
        }

        public void setForceLevel(Boolean forceLevel) {
            this.forceLevel = forceLevel;
        }
    }
}
