package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComPaymentTermRpcDtoParam;
import com.elitescloud.cloudt.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.comm.vo.save.ComPaymentTermSaveVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author shihao.ma
 * 2020/7/2
 */
public interface IComPaymentTermService {

    Optional<ComPaymentTermRespVO> findCodeOne(String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    Optional<ComPaymentTermRespVO> findIdOne(Long id);

    /**
     * 创建
     *
     * @param objDo 对象
     */
    Long createOne(ComPaymentTermSaveVO objDo);

    /**
     * 创建
     *
     * @param list 对象集合
     */
    List<Long> createBatch(List<ComPaymentTermSaveVO> list);

    /**
     * 更新
     *
     * @param objDo 对象
     */
    void update(ComPaymentTermSaveVO objDo);

    /**
     * 删除
     *
     * @param id 对象
     */
    void deleteOne(Long id);

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);


    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<ComPaymentTermRespVO> search(ComPaymentTermQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param code code
     * @return 对象
     */
    ComPaymentTermRespVO getCodeOne(String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    ComPaymentTermRespVO getIdOne(Long id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    List<ComPaymentTermRespVO> findIdBatch(List<Long> idList);

    List<ComPaymentTermRespVO> list();

    List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes);

    /**
     * 获取支付条款信息列表，该接口一般应用与如下场景
     * 1. 第三方通过code获取一些基本信息，用于后端组装数据
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     *
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     *
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    List<ComPaymentTermRpcDTO> findPaymentTermRpcDtoByParam(ComPaymentTermRpcDtoParam param);
}
