package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/12
 */
public interface SysTenantBasicDataService {

    /**
     * 向指定租户同步所有UDC
     *
     * @param tenantId 租户ID
     * @return 同步结果
     */
    ApiResult<Boolean> syncUdc(@NotNull Long tenantId);

    /**
     * 向所有租户同步UDC
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return 同步结果
     */
    ApiResult<Boolean> syncUdc(@NotBlank String appCode, @NotBlank String udcCode);

    /**
     * 向指定租户同步所有发号器
     *
     * @param tenantId 租户ID
     * @return 同步结果
     */
    ApiResult<Boolean> syncSequence(@NotNull Long tenantId);

    /**
     * 向所有租户同步发号器
     *
     * @param appCode  应用编码
     * @param ruleCode 发号器规则编码
     * @return 同步结果
     */
    ApiResult<Boolean> syncSequence(@NotBlank String appCode, @NotBlank String ruleCode);
}
