package com.elitescloud.cloudt.system.service.callback;

import com.elitescloud.cloudt.system.service.model.bo.SysOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;

/**
 * 组织信息变化后的回调.
 *
 * @author Kaiser（wang shao）
 * 2022/9/29
 */
public interface OrgChangedCallback {

    /**
     * 组织保存后的回调
     *
     * @param add    是否是新增操作
     * @param saveBO 保存参数
     * @param orgDO  组织entity
     */
    void onUpsert(boolean add, SysOrgSaveBO saveBO, SysOrgDO orgDO);

    /**
     * 启用、禁用
     *
     * @param orgId   组织ID
     * @param enabled 是否是启用操作
     */
    void onEnabled(Long orgId, boolean enabled);

    /**
     * 删除操作
     *
     * @param orgId 组织ID
     */
    void onDelete(Long orgId);
}
