package com.elitescloud.cloudt.system.service.callback;

import com.elitescloud.cloudt.system.service.model.entity.SysThirdPartyAccountDO;

/**
 * 第三方账号变更回调.
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
public interface ThirdPartyAccountChangedCallback {

    /**
     * 账号保存后的回调
     *
     * @param add       是否是新增操作
     * @param accountDO entity
     */
    void onUpsert(boolean add, SysThirdPartyAccountDO accountDO);

    /**
     * 启用、禁用
     *
     * @param accountId 账号ID
     * @param enabled   是否是启用操作
     */
    void onEnabled(Long accountId, boolean enabled);

    /**
     * 删除操作
     *
     * @param accountDO 实体信息
     */
    void onDelete(SysThirdPartyAccountDO accountDO);
}
