package com.elitescloud.cloudt.system.service.common.constant;

import com.elitescloud.boot.base.SafeEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysThirdPartyAccountDO;

/**
 * 第三方账号类型.
 *
 * {@link SysThirdPartyAccountDO#accountType}
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
public class ThirdPartAccountType extends SafeEnum<MenuTreeNodeType> {
    private static final long serialVersionUID = -5821046471116071415L;

    public static final ThirdPartAccountType WECHAT_MINI_APP = new ThirdPartAccountType("wechat_mini_app", "微信小程序");
    public static final ThirdPartAccountType WECHAT_SERVICE = new ThirdPartAccountType("wechat_service", "微信公众号");
    public static final ThirdPartAccountType WECHAT_SUBSCRIPTION = new ThirdPartAccountType("wechat_subscription", "微信订阅号");
    public static final ThirdPartAccountType WECOM = new ThirdPartAccountType("wecom", "企业微信");

    public ThirdPartAccountType() {
    }

    public ThirdPartAccountType(String value) {
        super(value);
    }

    public ThirdPartAccountType(String value, String description) {
        super(value, description);
    }

    public static ThirdPartAccountType valueOf(String value) {
        return SafeEnum.valueOf(ThirdPartAccountType.class, value);
    }
}
