package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据选择器分组.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Entity
@Table(name = "sys_data_selector_group", indexes = {
})
@Comment("数据选择器分组")
@DynamicInsert
@Getter
@Setter
public class SysDataSelectorGroupDO extends BaseModel {
    private static final long serialVersionUID = 6726370574025502431L;

    @Column(nullable = false)
    @Comment(value = "分组编码")
    private String groupCode;

    @Column(nullable = false)
    @Comment(value = "分组名称")
    private String groupName;

    @Column()
    @Comment(value = "启用状态", defaultValue = "1")
    private Boolean enabled;

    @Column()
    @Comment(value = "排序", defaultValue = "0")
    private Integer sortNo;

    @Column()
    @Comment(value = "描述")
    private String description;
}
