package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 项目版本信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/2
 */
@Entity
@Table(name = "sys_project_version", indexes = {
        @Index(name = "idx_projectversion_proj", columnList = "project"),
        @Index(name = "idx_projectversion_app", columnList = "applicationCode"),
})
@Comment("项目版本信息")
@DynamicInsert
@Getter
@Setter
public class SysProjectVersionDO extends BaseModel {
    private static final long serialVersionUID = -8461806780904676381L;

    @Column()
    @Comment(value = "项目编码")
    private String project;

    @Column()
    @Comment(value = "项目名称")
    private String projectName;

    @Column()
    @Comment(value = "环境编码")
    private String env;

    @Column()
    @Comment(value = "项目名称")
    private String envName;

    @Column()
    @Comment(value = "应用编码")
    private String applicationCode;

    @Column()
    @Comment(value = "应用名称")
    private String applicationName;

    @Column()
    @Comment(value = "jdk版本")
    private String javaVersion;

    @Column()
    @Comment(value = "Spring版本")
    private String springVersion;

    @Column()
    @Comment(value = "SpringBoot版本")
    private String springBootVersion;

    @Column()
    @Comment(value = "云梯架构版本")
    private String cloudtBootVersion;

    @Column()
    @Comment(value = "项目版本号")
    private String projectVersion;

    @Column()
    @Comment(value = "操作系统")
    private String osName;

    @Column()
    @Comment(value = "构建时间")
    private String buildTime;

    @Column()
    @Comment(value = "构建时间")
    private LocalDateTime buildDateTime;

    @Column()
    @Comment(value = "上报者IP")
    private String reporterIp;

    @Column()
    @Comment(value = "上报时间")
    private LocalDateTime reportTime;
}
