package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 角色与字段权限的关联.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@Entity
@Table(name = "sys_role_field_permission", indexes = {
        @Index(name = "idx_role_fieldperm_role", columnList = "roleCode"),
        @Index(name = "idx_role_fieldperm_type", columnList = "permissionType"),
        @Index(name = "idx_role_fieldperm_menu", columnList = "menuCode"),
        @Index(name = "idx_role_fieldperm_obj", columnList = "businessObjectCode"),
        @Index(name = "idx_role_fieldperm_opera", columnList = "operationCode"),
})
@Comment("角色与字段权限的关联")
@DynamicInsert
@Getter
@Setter
public class SysRoleFieldPermissionDO extends BaseModel {
    private static final long serialVersionUID = -1961482211974390251L;

    @Column(nullable = false)
    @Comment("角色编码")
    private String roleCode;

    /**
     * {@link DataPermissionType}
     */
    @Column(nullable = false)
    @Comment("权限类型")
    private String permissionType;

    @Column()
    @Comment("应用编码")
    private String appCode;

    @Column()
    @Comment("菜单编码")
    private String menuCode;

    @Column()
    @Comment("业务对象编码")
    private String businessObjectCode;

    @Column()
    @Comment("操作编码")
    private String operationCode;

    @Column()
    @Comment("字段名称")
    private String fieldName;

    @Column()
    @Comment(value = "可读", defaultValue = "1")
    private Boolean readable;

    @Column()
    @Comment(value = "可写", defaultValue = "1")
    private Boolean writeable;
}
