package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 导入导出历史记录.
 *
 * @author Kaiser（wang shao）
 * @date 2/15/2023
 */
@Entity
@Table(name = "sys_tmpl_import_record", indexes = {
        @Index(name = "idx_tmpl_imp_record_tmpl", columnList = "tmplId"),
        @Index(name = "idx_tmpl_imp_record_tmplc", columnList = "tmplCode"),
})
@Comment("导入导出历史记录")
@DynamicInsert
@Getter
@Setter
public class SysTmplImportRecordDO extends BaseModel {
    private static final long serialVersionUID = -3956125157102564048L;

    @Column(nullable = false)
    @Comment("模板ID")
    private Long tmplId;

    @Comment("模板编码")
    private String tmplCode;

    @Column()
    @Comment("文件的标识")
    private String fileCode;

    @Column()
    @Comment(value = "是否是导出", defaultValue = "1")
    private Boolean export;

    @Column()
    @Comment("操作用户ID")
    private Long userId;

    @Column()
    @Comment("操作用户名称")
    private String userName;

    @Column()
    @Comment("开始时间")
    private LocalDateTime timeImport;

    @Column()
    @Comment("结束时间")
    private LocalDateTime timeFinish;

    @Column()
    @Comment(value = "是否结束", defaultValue = "0")
    private Boolean finish;

    @Column()
    @Comment(value = "是否成功", defaultValue = "0")
    private Boolean succ;

    @Column()
    @Lob
    @Comment("失败原因")
    private String failReason;

    @Column()
    @Comment("自定义提示信息")
    private String customTipMsg;

    @Column()
    @Comment(value = "总数量", defaultValue = "0")
    private Long numTotal;

    @Column()
    @Comment(value = "成功数量", defaultValue = "0")
    private Long numSuc;

    @Column()
    @Lob
    @Comment("查询参数")
    private String queryParam;

    @Column()
    @Comment("失败记录的文件编码")
    private String failFileCode;

    @Column()
    @Lob
    @Comment("耗时信息")
    private String costTimeInfo;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTmplImportRecordDO) {
            SysTmplImportRecordDO the = (SysTmplImportRecordDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
