package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 统一查询记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/5
 */
@Entity
@Table(name = "sys_unify_query_record", indexes = {
        @Index(name = "idx_unifyquery_rd_user", columnList = "userId"),
        @Index(name = "idx_unifyquery_rd_app", columnList = "appCode"),
        @Index(name = "idx_unifyquery_rd_bus", columnList = "businessObjectCode"),
        @Index(name = "idx_unifyquery_rd_querytime", columnList = "queryTime"),
})
@Comment("统一查询记录")
@DynamicInsert
@Getter
@Setter
public class SysUnifyQueryRecordDO extends BaseModel {
    private static final long serialVersionUID = 8355669389637792960L;

    @Comment(value = "查询用户ID")
    @Column()
    private Long userId;

    @Comment(value = "查询时间")
    @Column()
    private LocalDateTime queryTime;

    @Comment(value = "查询结束时间")
    @Column()
    private LocalDateTime finishTime;

    @Comment(value = "耗时，毫秒")
    @Column()
    private Long costTime;

    @Comment(value = "是否查询成功", defaultValue = "1")
    @Column()
    private Boolean success;

    @Comment(value = "失败原因")
    @Column()
    @Lob
    private String failReason;

    @Comment(value = "所属应用编码")
    @Column()
    private String appCode;

    @Comment(value = "查询业务对象编码")
    @Column()
    private String businessObjectCode;

    @Comment(value = "查询业务字段")
    @Column()
    private String businessFields;

    @Comment(value = "查询业务参数")
    @Column()
    private String businessParams;

    /**
     * {@link com.elitescloud.cloudt.system.service.common.constant.UnifyQueryTypeEnum}
     */
    @Comment(value = "查询类型")
    @Column()
    private String queryType;

    @Comment(value = "SQL")
    @Column()
    @Lob
    private String sqlTxt;

    @Comment(value = "SQL参数")
    @Column()
    @Lob
    private String sqlParams;

    @Comment(value = "查询结果")
    @Column()
    @Lob
    private String queryResult;
}
