package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.constant.UserType;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/26
 */
@Entity
@Table(name = "sys_user_type", indexes = {
        @Index(name = "idx_sys_user_type_user_id", columnList = "userId"),
        @Index(name = "idx_sys_user_type_type", columnList = "type"),
        @Index(name = "idx_sys_user_type_idt", columnList = "identityId"),
})
@Comment("用户类型")
@Getter
@Setter
public class SysUserTypeDO extends BaseModel {
    private static final long serialVersionUID = -7517013881233918756L;

    /**
     * 用户ID
     */
    @Column(nullable = false)
    @Comment("用户ID")
    private Long userId;

    /**
     * 用户类型
     * {@link UserType}
     */
    @Column(nullable = false)
    @Comment("用户类型")
    private String type;

    /**
     * 身份ID
     */
    @Column()
    @Comment("身份ID")
    private String identityId;

    /**
     * 所属租户
     */
    @Column()
    @Comment("所属租户")
    private Long sysTenantId;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysUserTypeDO) {
            SysUserTypeDO the = (SysUserTypeDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
