package com.elitescloud.cloudt.system.service.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 行政区域树查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/19
 */
@Getter
@Setter
@ApiModel(description = "行政区域树查询参数")
public class CommonAreaTreeQueryVO implements Serializable {
    private static final long serialVersionUID = 7366759222054954592L;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID", position = 1)
    private Long pid;

    /**
     * 上级编码
     */
    @ApiModelProperty(value = "上级编码", position = 2)
    private String pcode;

    @ApiModelProperty(value = "是否仅中国", position = 3)
    private Boolean cn;

    @ApiModelProperty(value = "是否返回树状", position = 4)
    private Boolean tree;
}
