package com.elitescloud.cloudt.system.service.model.bo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 数据权限批量保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/20
 */
@Data
public class SysDprBatchSaveBO {

    /**
     * 角色ID
     */
    @NotNull
    private Long roleId;

    /**
     * 菜单接口列表
     */
    @NotEmpty
    private List<MenuApiSaveBO> menuApiList;

    /**
     * 自定义规则列表
     */
    private List<SysDprApiCustomRuleSaveBO> customRuleList = new ArrayList<>(0);

    /**
     * 保存策略
     */
    private Strategy strategy;

    @Data
    public static class MenuApiSaveBO implements Serializable {
        private static final long serialVersionUID = -4470397180143148515L;
        /**
         * 菜单编码
         */
        @NotBlank
        private String menuCode;

        /**
         * 接口编码
         */
        @NotBlank
        private String apiCode;
    }

    public enum Strategy {
        /**
         * 直接在原有基础上追加
         */
        APPEND,
        /**
         * 根据接口编码替换原有
         */
        REPLACE,
        /**
         * 先情况原有的
         */
        CLEAR
    }
}
