package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;

/**
 * 银行信息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/13 周四
 */
@Entity
@Table(name = "sys_bank", indexes = {
        @Index(name = "idx_sys_bank_type", columnList = "bankType"),
        @Index(name = "idx_sys_bank_code", columnList = "bankCode"),
        @Index(name = "idx_sys_bank_pcode", columnList = "pcode"),
})
@Comment("银行信息")
@DynamicInsert
@Getter
@Setter
public class SysBankDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = -1949821681963192658L;

    /**
     * @see com.elitescloud.cloudt.constant.SysBankType
     */
    @Comment("银行类型, [UDC]cloudt-system:sysBank")
    @Column(nullable = false, length = 32)
    private String bankType;

    @Comment("银行编号")
    @Column(nullable = false, length = 32)
    private String bankCode;

    @Comment("银行名称")
    @Column(nullable = false, length = 128)
    private String bankName;

    @Comment("上级编码")
    @Column(length = 32)
    private String pcode;

    @Comment("人行联行行号")
    @Column(length = 32)
    private String unitedBankNo;

    @Comment("人行联行名称")
    @Column(length = 128)
    private String unitedBankName;

    @Comment("外部编码")
    @Column(length = 32)
    private String outerCode;

    @Comment("排序号")
    @Column()
    private Integer sortNo;

    @Comment("详细地址")
    @Column(length = 256)
    private String detailAddr;
}
