package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysSyncDO;
import com.elitescloud.cloudt.system.service.model.entity.SysSyncDO;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/26
 */
@Repository
public class SyncRepoProc extends BaseRepoProc<SysSyncDO> {
    private static final QSysSyncDO QDO = QSysSyncDO.sysSyncDO;

    protected SyncRepoProc() {
        super(QDO);
    }

    /**
     * 更新同步结果
     *
     * @param id
     * @param success
     * @param outerDataKey
     * @param failReason
     */
    public void updateSyncResult(long id, boolean success, String outerDataKey, String failReason) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.syncSuccess, success)
                .set(QDO.outerDataKey, outerDataKey)
                .set(QDO.failReason, failReason)
                .set(QDO.syncDataTime, LocalDateTime.now())
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 删除数据
     *
     * @param dataType
     * @param dataKey
     * @param outerApp
     * @return
     */
    public void delete(@NotBlank String dataType, @NotBlank String dataKey, String outerApp) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.dataKey, dataKey)
                .andEq(QDO.dataType, dataType)
                .andEq(QDO.outerApp, outerApp)
                .build();
        super.delete(predicate);
    }

    /**
     * 获取数据的外部标识
     *
     * @param dataType
     * @param dataKey
     * @param outerApp
     * @return
     */
    public String getOuterDataKey(@NotBlank String dataType, @NotBlank String dataKey, String outerApp) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.dataKey, dataKey)
                .andEq(QDO.dataType, dataType)
                .andEq(QDO.outerApp, outerApp)
                .build();
        return super.getValue(QDO.outerDataKey, predicate);
    }

    public Map<String, String> getOuterDataKeys(@NotBlank String dataType, @NotBlank Collection<String> dataKey, String outerApp) {
        var predicate = PredicateBuilder.builder()
                .andIn(QDO.dataKey, dataKey)
                .andEq(QDO.dataType, dataType)
                .andEq(QDO.outerApp, outerApp)
                .build();
        return super.jpaQueryFactory.select(QDO.dataKey, QDO.outerDataKey)
                .from(QDO)
                .where(predicate)
                .fetch()
                .stream()
                .filter(t -> StringUtils.hasText(t.get(QDO.outerDataKey)))
                .collect(Collectors.toMap(t -> t.get(QDO.dataKey), t -> t.get(QDO.outerDataKey), (t1, t2) -> t1));
    }

    /**
     * 获取数据的外部标识
     *
     * @param dataType
     * @param dataKey
     * @param outerApp
     * @return
     */
    public IdCodeNameParam getIdCode(@NotBlank String dataType, @NotBlank String dataKey, String outerApp) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.dataKey, dataKey)
                .andEq(QDO.dataType, dataType)
                .andEq(QDO.outerApp, outerApp)
                .build();
        var qbean = Projections.bean(IdCodeNameParam.class, QDO.id, QDO.outerDataKey.as("code"));
        return super.getOne(qbean, predicate);
    }
}
