package com.elitescloud.cloudt.system.service.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @author Chris
 * 2021-07-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("当前用户所拥有的权限")
public class SysCurrentUserPermissions implements Comparable<SysCurrentUserPermissions>, Serializable {

    private static final long serialVersionUID = -7654739077156462586L;

    /**
     * 权限ID
     */
    @ApiModelProperty("权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("父ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long parentId;

    /**
     * 权限编号
     */
    @ApiModelProperty("权限编号")
    private String code;

    /**
     * 权限名称
     */
    @ApiModelProperty("权限名称")
    private String name;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private Integer sortNo;

    /**
     * 路由
     */
    @ApiModelProperty("路由")
    private String pattern;

    /**
     * 菜单是否隐藏
     */
    @ApiModelProperty("菜单是否隐藏")
    private Boolean isHidden;

    /**
     * 图标
     */
    private String icon;

    /**
     * 当前子节点数据
     */
    @ApiModelProperty("子节点数据")
    private List<SysCurrentUserPermissions> childNodes = Collections.emptyList();

    @Override
    public int compareTo(SysCurrentUserPermissions node) {
        return this.sortNo - node.sortNo;
    }

}
