package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Map;

/**
 * 系统预警管理服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
public interface SysAlertService {
    String BUSINESS_TYPE_DEFAULT = "default";
    /**
     * 外部接口
     */
    String BUSINESS_TYPE_THIRD_API = "thirdApi";
    /**
     * SQL执行
     */
    String BUSINESS_TYPE_SQL_EXECUTE = "sqlExecute";

    /**
     * 根据模板发送预警
     *
     * @param businessType 业务类型
     * @param category     配置分类
     * @param tmplParams   模板参数
     * @return 发送结果
     */
    ApiResult<Boolean> sendAlertByTmpl(@NotBlank String businessType, String category, @NotEmpty Map<String, Object> tmplParams);

    /**
     * 发送预警
     *
     * @param businessType 业务类型
     * @param category     配置分类
     * @param content      预警内容
     * @return 发送结果
     */
    ApiResult<Boolean> sendAlert(@NotBlank String businessType, String category, @NotBlank String content);
}
