package com.elitescloud.cloudt.system.service.common.constant;

import com.elitescloud.boot.base.SafeEnum;

/**
 * 菜单树节点类型.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
public final class MenuTreeNodeType extends SafeEnum<MenuTreeNodeType> {
    private static final long serialVersionUID = 3464747099370145285L;

    public static final MenuTreeNodeType APP = new MenuTreeNodeType("APP", "应用");
    public static final MenuTreeNodeType MENU_GROUP = new MenuTreeNodeType("MENU_GROUP", "菜单分组");
    public static final MenuTreeNodeType MENU = new MenuTreeNodeType("MENU", "菜单");
    public static final MenuTreeNodeType ACTION = new MenuTreeNodeType("ACTION", "操作");
    /**
     * @deprecated 已弃用，改用 {@link #BUSINESS_OPERATION}
     */
    @Deprecated(since = "3.3.0")
    public static final MenuTreeNodeType API = new MenuTreeNodeType("API", "API接口");
    public static final MenuTreeNodeType BUSINESS_OBJECT = new MenuTreeNodeType("BUSINESS_OBJECT", "业务对象");
    public static final MenuTreeNodeType BUSINESS_OPERATION = new MenuTreeNodeType("BUSINESS_OPERATION", "业务对象操作");

    public MenuTreeNodeType() {
    }

    public MenuTreeNodeType(String value) {
        super(value);
    }

    public MenuTreeNodeType(String value, String description) {
        super(value, description);
    }

    public static MenuTreeNodeType valueOf(String value) {
        return SafeEnum.valueOf(MenuTreeNodeType.class, value);
    }

    public static MenuTreeNodeType valueOfPlatformMenu(String menuType) {
        if (menuType == null) {
            return null;
        }
        if ("MENUS".equals(menuType)) {
            return MENU;
        }
        if ("MENUS_GROUP".equals(menuType)) {
            return MENU_GROUP;
        }
        if ("BUTTON".equals(menuType)) {
            return ACTION;
        }
        return null;
    }
}
