package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.constant.SysOuType;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 公司.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/1
 */
@Entity
@Table(name = "sys_ou", indexes = {
        @Index(name = "idx_ou_code", columnList = "ouCode"),
        @Index(name = "idx_ou_name", columnList = "ouName"),
})
@Comment("公司")
@DynamicInsert
@Getter
@Setter
public class SysOuDO extends BaseModel {
    private static final long serialVersionUID = 832474966138022190L;

    @Comment(value = "公司编码")
    @Column(nullable = false)
    private String ouCode;

    @Comment(value = "公司名称")
    @Column(nullable = false)
    private String ouName;

    @Comment(value = "名称拼音")
    @Column()
    private String pinyin;

    @Comment(value = "简称")
    @Column()
    private String ouAbbr;

    /**
     * {@link SysOuType}
     */
    @Comment(value = "公司类型，[UDC]cloudt-system:ouType")
    @Column()
    private String ouType;

    @Comment(value = "顺序", defaultValue = "0")
    @Column()
    private Integer sortNo;

    @Comment(value = "是否启用", defaultValue = "0")
    @Column()
    private Boolean enabled;

    @Comment(value = "公司法人")
    @Column()
    private String legalPerson;

    @Comment(value = "工商登记号")
    @Column()
    private String icRegisterNo;

    @Comment(value = "电话号")
    @Column()
    private String phone;

    @Comment(value = "公司邮箱")
    @Column()
    private String email;

    @Comment(value = "法人公司ID")
    @Column()
    private Long legalOuId;

    @Comment(value = "所属区域，[UDC]cloudt-system:region")
    @Column()
    private String region;

    @Column()
    @Comment("国家编码")
    private String countryCode;

    @Comment(value = "所在地-省份编码")
    @Column()
    private String provinceCode;

    @Comment(value = "所在地-市编码")
    @Column()
    private String cityCode;

    @Comment(value = "所在地-县编码")
    @Column()
    private String countyCode;

    @Comment(value = "详细地址")
    @Column()
    private String address;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysOuDO) {
            SysOuDO the = (SysOuDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
