package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 权限资源配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/29
 */
@Entity
@Table(name = "sys_permission_res", indexes = {
        @Index(name = "idx_permission_res_res", columnList = "resId"),
        @Index(name = "idx_permission_res_owner", columnList = "ownerId"),
        @Index(name = "idx_permission_res_assigner", columnList = "assignerId"),
})
@Comment("权限资源配置")
@DynamicInsert
@Getter
@Setter
public class SysPermissionResDO extends BaseModel {
    private static final long serialVersionUID = 6768736855058869917L;

    /**
     * {@link com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType}
     */
    @Comment(value = "资源类型")
    @Column(nullable = false)
    private String resType;

    @Comment(value = "资源标识")
    @Column(nullable = false)
    private String resId;

    /**
     * {@link com.elitescloud.cloudt.system.service.common.constant.PermissionOwnerTypeEnum}
     */
    @Comment(value = "持有者类型")
    @Column(nullable = false)
    private String ownerType;

    @Comment(value = "持有者标识")
    @Column(nullable = false)
    private String ownerId;

    /**
     * {@link com.elitescloud.cloudt.system.service.common.constant.BelongType}
     */
    @Comment(value = "分配者类型")
    @Column(nullable = false)
    private String assignerType;

    @Comment(value = "分配者标识")
    @Column(nullable = false)
    private String assignerId;
}
