package com.elitescloud.cloudt.system.service.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/16
 */
@ApiModel(description = "用户头像信息")
@Data
public class SysUserAvatarUpdateParam implements Serializable {
    private static final long serialVersionUID = -9109647046491368087L;

    @ApiModelProperty(value = "用户头像地址，可直接访问，如微信头像地址等", position = 1)
    @Size(max = 1000, message = "头像路径过长")
    private String avatarUrl;

    @ApiModelProperty(value = "用户头像编码，图片在文件服务器中的标识，与avatarUrl二选一即可", position = 2)
    @Size(max = 32, message = "头像编码过长")
    private String avatarCode;
}
