package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2023/1/10
 */
@Repository
public class AppRepoProc extends BaseRepoProc<SysPlatformAppDO> {
    private static final QSysPlatformAppDO QDO = QSysPlatformAppDO.sysPlatformAppDO;

    public AppRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码获取ID
     *
     * @param code 应用编码
     * @return 应用ID
     */
    public Long getIdByCode(@NotBlank String code) {
        return super.getIdByValue(QDO.appCode, code);
    }

    /**
     * 根据ID获取应用编码
     *
     * @param id 应用ID
     * @return 应用编码
     */
    public String getCode(long id) {
        return super.getValue(QDO.appCode, id);
    }

    public String getCode(String appCode) {
        return super.getValueByValue(QDO.appCode, QDO.appCode, appCode);
    }

    /**
     * 根据编码获取名称
     *
     * @param appCode
     * @return
     */
    public String getNameByCode(@NotBlank String appCode) {
        return super.getValueByValue(QDO.appName, QDO.appCode, appCode);
    }

    /**
     * 根据应用编码获取应用信息
     *
     * @param code 应用编码
     * @return 应用信息
     */
    public SysPlatformAppDO getByCode(@NotBlank String code) {
        return super.getOneByValue(QDO.appCode, code);
    }

    public List<IdCodeNameParam> allParams(Boolean enabled) {
        return jpaQueryFactory.select(Projections.bean(IdCodeNameParam.class, QDO.id, QDO.appCode.as("code"), QDO.appName.as("name")))
                .from(QDO)
                .where(enabled == null ? null : QDO.appState.eq(enabled))
                .orderBy(defaultOrder())
                .fetch()
                ;
    }

    public List<AppBO> allBO(Boolean enabled) {
        return super.getList(qBeanBo(), enabled == null ? null : QDO.appState.eq(enabled), defaultOrder());
    }

    public List<String> allCodes(Boolean enabled) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.appState, enabled)
                .build();
        return super.getValueList(QDO.appCode, predicate);
    }

    private QBean<AppBO> qBeanBo() {
        return Projections.bean(AppBO.class, QDO.id, QDO.appCode, QDO.appName, QDO.appOrder, QDO.icon, QDO.adaptedTerminal);
    }

    private OrderSpecifier<?> defaultOrder() {
        return QDO.appOrder.asc();
    }
}
