package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.dto.SysUserTerminalSaveDTO;
import com.elitescloud.cloudt.system.service.vo.save.SysUserTerminalSaveVO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/28
 */
public interface SysUserTerminalService {

    /**
     * 保存用户用户与终端关联
     *
     * @param saveVO 保存信息
     * @return 用户ID
     */
    ApiResult<Long> save(SysUserTerminalSaveVO saveVO);

    /**
     * 保存用户与终端关联
     * <p>
     * 以参数中的终端作为用户的所有终端
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    ApiResult<Long> save(SysUserTerminalSaveDTO saveParam);

    /**
     * 保存用户与终端关联
     * <p>
     * 以参数中的终端作为用户的所有终端
     *
     * @param userId    用户ID
     * @param terminals 终端
     * @return 用户ID
     */
    ApiResult<Long> save(Long userId, Set<Terminal> terminals);

    /**
     * 新增终端绑定
     * <p>
     * 在用户已有的终端的基础上新增
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    ApiResult<Long> saveForAdd(SysUserTerminalSaveDTO saveParam);

    /**
     * 新增终端绑定
     * <p>
     * 在用户已有的终端的基础上新增
     *
     * @param userId    用户ID
     * @param terminals 终端
     * @return 用户ID
     */
    ApiResult<Long> saveForAdd(Long userId, Set<Terminal> terminals);

    /**
     * 减少终端绑定
     * <p>
     * 在用户已有的终端的基础上减少
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    ApiResult<Long> saveForReduce(SysUserTerminalSaveDTO saveParam);

    /**
     * 获取用户关联的终端
     *
     * @param userId 用户ID
     * @return 关联的终端列表
     */
    ApiResult<List<Terminal>> getByUser(Long userId);

    /**
     * 获取用户关联的终端
     *
     * @param username 用户的登录名
     * @return 关联的终端列表
     */
    ApiResult<List<Terminal>> getByUser(String username);

    /**
     * 批量获取用户关联的终端
     *
     * @param userIds 用户ID
     * @return 用户及管理的终端列表
     */
    ApiResult<Map<Long, List<Terminal>>> getByUser(List<Long> userIds);

}
