package com.elitescloud.cloudt.system.service.common.constant;

/**
 * 应用授权类型.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/18
 */
public enum AppAuthTypeEnum {

    /**
     * 需要授权
     * <p>
     * 默认的类型，通过角色方式授权
     */
    AUTHED("角色授权"),
    /**
     * 无需授权
     * <p>
     * 所有账号都会有
     */
    UNNECESSARY("无需授权"),
    /**
     * 自定义
     */
    CUSTOM("自定义授权");

    private final String description;

    AppAuthTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }
}
