package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.constant.CurrencyRateCalcMethod;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 税率.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
@Entity
@Table(name = "sys_currency_rate", indexes = {
        @Index(name = "idx_currency_rate_from", columnList = "fromCurr"),
})
@Comment("汇率")
@DynamicInsert
@Getter
@Setter
public class SysCurrencyRateDO extends BaseStdModel {
    private static final long serialVersionUID = -207647802238777904L;

    /**
     * 自货币码
     */
    @Column(nullable = false)
    @Comment("自货币码")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private String fromCurr;

    /**
     * 至货币码
     */
    @Column(nullable = false)
    @Comment("至货币码")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private String toCurr;

    /**
     * 汇率
     */
    @Column(nullable = false, precision = 20, scale = 8)
    @Comment("汇率")
    private BigDecimal ratio;

    /**
     * 算法
     * {@link CurrencyRateCalcMethod}
     */
    @Column(nullable = false)
    @Comment("算法")
    private String calMethod;

    /**
     * 是否启用
     */
    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean enabled;

    /**
     * 有效时间-起始
     */
    @Column()
    @Comment(value = "有效时间-起始")
    private LocalDateTime validFrom;

    /**
     * 有效时间-截止
     */
    @Column()
    @Comment(value = "有效时间-截止")
    private LocalDateTime validTo;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysCurrencyRateDO) {
            SysCurrencyRateDO the = (SysCurrencyRateDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
