package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserOuterappDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserOuterappDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/11
 */
@Repository
public class SysUserOuterappRepoProc extends BaseRepoProc<SysUserOuterappDO> {
    private static final QSysUserOuterappDO QDO = QSysUserOuterappDO.sysUserOuterappDO;

    public SysUserOuterappRepoProc() {
        super(QDO);
    }

    /**
     * 获取用户的外部应用标识
     *
     * @param userId
     * @param outerAppId
     * @return
     */
    public String getOpenIdByUserIdAndOuterAppId(long userId, @NotBlank String outerAppId) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.userId, userId)
                .andEq(QDO.outerAppId, outerAppId)
                .build();
        return super.getValue(QDO.openId, predicate);
    }

    /**
     * 根据外部应用标识获取用户ID
     *
     * @param openId
     * @param outerAppId
     * @return
     */
    public Long getUserIdByOpenIdAndOuterAppId(@NotBlank String openId, @NotBlank String outerAppId) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.openId, openId)
                .andEq(QDO.outerAppId, outerAppId)
                .build();
        return super.getValue(QDO.userId, predicate);
    }

    public void deleteByAppIdAndUserId(long userId, @NotBlank String outerAppId) {
        super.delete(QDO.userId.eq(userId).and(QDO.outerAppId.eq(outerAppId)));
    }
}
