package com.elitescloud.cloudt.system.spi;

import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.vo.SysUserPagingVO;
import com.elitescloud.cloudt.system.service.vo.component.SysUserComponentPagingVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/4/8
 */
public interface SysUserQuerySpi {

    /**
     * 服务名称
     * @return
     */
    String getServiceName();

    /**
     * 用户查询字段及表
     *
     * @return
     */
    JPAQuery<SysUserDO> selectSysUserForJpaQuery();

    /**
     * 查询条件
     *
     * @return
     */
    Predicate selectSysUserForPredicate();

    /**
     * 用户查询字段及表
     *
     * @return
     */
    JPAQuery<SysUserPagingVO> findPagingForJpaQuery();

    /**
     * 查询条件
     *
     * @return
     */
    Predicate findPagingForPredicate();

    /**
     * 组件查询
     *
     * @return
     */
    JPAQuery<SysUserComponentPagingVO> findSysUserComPagingByParamForJpaQuery();

    /**
     * 组件查询
     * @return
     */
    Predicate findSysUserComPagingByParamForPredicate();
}
