package com.elitescloud.cloudt.system.spi;

import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;

/**
 * @author : chen
 *  角色数据权限，规则的系统内置类型的值处理SPI。
 * 让外部自己定义  默认实现 @Order 99  扩展的SPI需要定义小于 @Order 99才可以生效
 * 2022-12-01 12:36
 */
public interface DprSysRuleSysInternallyValueSpi {


    /**
     * 系统内置类型的规则的值与字段逻辑接口。 根据当前用户信息，规则信息，计算出数据权限规则的规则字段域与规则值信息。
     * 接口需要实现 DprSysInternallyEnum 枚举中的全部内置类型的取值逻辑
     * @param userInfo 用户信息
     * @param ruleDTO  规则信息
     * @param sysInternallyEnum 系统内置类型枚举 用于判断如何处理
     * @return DprRuleValueSysInternallyBo 规则字段信息与规则值信息
     */
    DprRuleValueSysInternallyBo getSysInternallyRuleFieldRuleValue(GeneralUserDetails userInfo,
                                                                   SysDprRoleApiDataRuleListQueryDTO ruleDTO,
                                                                   DprSysInternallyEnum sysInternallyEnum);

}
