package com.elitescloud.cloudt.tenant.config;

import com.elitescloud.boot.constant.TenantConstant;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

/**
 * 租户服务端配置属性.
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
@ConfigurationProperties(prefix = TenantProperties.CONFIG_PREFIX)
public class TenantProperties {

    static final String CONFIG_PREFIX = TenantConstant.CONFIG_SERVICE_PREFIX;

    /**
     * 是否自动同步租户数据库ddl，创建租户成功后
     */
    private boolean autoSyncDb = false;

    /**
     * 是否是异步调用更新租户数据库ddl
     */
    private boolean asyncCall = true;

    /**
     * 等待客户端创建schema超时时间，单位毫秒
     */
    private Integer createTimeOut = (int) Duration.ofMinutes(30).toMillis();

    /**
     * 是否自动从注册中心获取客户端
     */
    private boolean discoveryClient = true;

    /**
     * 所有租户客户端名称（应用名称，如cloudt-system）,当discoveryClient=false时自动获取
     */
    private Set<String> clientNames = new HashSet<>();

    /**
     * 是否限制租户的登录，限制后租户将只能通过自己相关的域名登录
     */
    private boolean limitTenantLogin = true;

    public boolean isAutoSyncDb() {
        return autoSyncDb;
    }

    public void setAutoSyncDb(boolean autoSyncDb) {
        this.autoSyncDb = autoSyncDb;
    }

    public boolean isAsyncCall() {
        return asyncCall;
    }

    public void setAsyncCall(boolean asyncCall) {
        this.asyncCall = asyncCall;
    }

    public Integer getCreateTimeOut() {
        return createTimeOut;
    }

    public void setCreateTimeOut(Integer createTimeOut) {
        this.createTimeOut = createTimeOut;
    }

    public boolean isDiscoveryClient() {
        return discoveryClient;
    }

    public void setDiscoveryClient(boolean discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public Set<String> getClientNames() {
        return clientNames;
    }

    public void setClientNames(Set<String> clientNames) {
        this.clientNames = clientNames;
    }

    public boolean isLimitTenantLogin() {
        return limitTenantLogin;
    }

    public void setLimitTenantLogin(boolean limitTenantLogin) {
        this.limitTenantLogin = limitTenantLogin;
    }
}
