package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.model.vo.SysUserTenantVO;
import com.elitescloud.cloudt.tenant.service.ApiTenantService;
import com.elitescloud.cloudt.tenant.service.SysTenantMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 租户用户管理
 *
 * @author roman.zhang
 * @since 2022-02-16 15:15:58
 */
@ResponseBody
@RequestMapping(value = "/sys/tenant/user", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "租户用户绑定", tags = {"租户管理"})
public class SysTenantUserController {

    @Autowired
    private SysTenantMngService sysTenantService;
    @Autowired
    private ApiTenantService apiTenantService;

    /**
     * 给用户绑定租户
     *
     * @param userId   用户ID
     * @param tenantId 租户ID
     */
    @ApiOperation("给用户绑定租户")
    @ApiOperationSupport(order = 21)
    @PutMapping("/{userId}/bind/{tenantId}")
    public ApiResult<Long> bindTenant(@PathVariable Long userId, @PathVariable Long tenantId) {
        return sysTenantService.updateUserBindTenant(userId, tenantId);
    }

    /**
     * 给用户解绑租户
     *
     * @param userId   用户ID
     * @param tenantId 租户ID
     */
    @ApiOperation("给用户解绑租户")
    @ApiOperationSupport(order = 22)
    @PutMapping("/{userId}/unbind/{tenantId}")
    public ApiResult<Long> unbindTenant(@PathVariable Long userId, @PathVariable Long tenantId) {
        return sysTenantService.updateUserUnbindTenant(userId, tenantId);
    }

    /**
     * 查询用户绑定的租户信息
     *
     * @param sysUserId 用户ID
     * @return
     */
    @ApiOperation("查询用户绑定的租户信息")
    @ApiOperationSupport(order = 23)
    @GetMapping(value = "/tenants")
    public ApiResult<List<SysUserTenantVO>> queryTenantOfUser(Long sysUserId) {
        return sysTenantService.queryTenantOfUser(sysUserId);
    }

    /**
     * 设置当前登录的租户
     *
     * @param tenantId 租户ID
     * @return
     */
    @ApiOperation("设置当前登录的租户")
    @ApiOperationSupport(order = 23)
    @GetMapping(value = "/setCurrentTenant/{tenantId}")
    public ApiResult<Boolean> execSetCurrentTenant(@PathVariable Long tenantId) {
        return apiTenantService.execSetCurrentTenant(tenantId);
    }
}


