package com.elitescloud.cloudt.tenant.model.vo.params;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 平台租户表(SysTenant)实体类
 *
 * @author roman.zhang
 * @since 2022-02-16 15:16:03
 */

@Data
@ApiModel(value = "sys_tenant", description = "平台租户表")
public class SysTenantQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 457020622087328879L;

    /**
     * 租户编码
     */
    @ApiModelProperty(value = "租户编码")
    private String tenantCode;

    /**
    * 租户名称
    */
    @ApiModelProperty("租户名称")
    private String tenantName;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    /**
    * 联系人
    */
    @ApiModelProperty("联系人")
    private String linkman;

    /**
    * 联系电话
    */
    @ApiModelProperty("联系电话")
    private String contactNumber;

    /**
     * schema名称，支持英文字母、数字和下划线
     */
    @ApiModelProperty(value = "schema名称")
    private String schemaName;

    /**
     * 域名地址
     */
    @ApiModelProperty("域名地址")
    private String tenantDomain;

    /**
     * 租户自定义域名
     */
    @ApiModelProperty(value = "租户自定义域名")
    private String customDomain;

    /**
     * 所属行业，[UDC]COM:INDUSTRY
     */
    @ApiModelProperty(value = "所属行业，[UDC]COM:INDUSTRY", position = 33)
    private String industry;

    /**
     * 所属客户，[UDC]SYS:CUSTOMER
     */
    @ApiModelProperty(value = "所属客户，[UDC]SYS:CUSTOMER", position = 34)
    private String customer;
}
