package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.tenant.model.vo.ApiTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.ApiTenantQueryParamVO;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/4/24
 */
public interface ApiTenantService {

    /**
     * 获取所有租户信息
     *
     * @return
     */
    ApiResult<List<ApiTenantVO>> queryAll();

    /**
     * 分页查询租户信息
     *
     * @param queryParamVO
     * @return
     */
    ApiResult<PagingVO<ApiTenantVO>> query(@RequestBody ApiTenantQueryParamVO queryParamVO);

    /**
     * 设置当前登录的租户
     *
     * @param id 租户ID
     * @return
     */
    ApiResult<Boolean> execSetCurrentTenant(Long id);
}
