package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.tenant.model.vo.SysTenantDbMigrateVO;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/28
 */
public interface SysTenantDbMigrateService {

    /**
     * 新增租户db迁移
     *
     * @param tenantDO        租户信息
     * @param isolateStrategy 迁移策略
     * @param appCode         项目代码
     * @return 新增结果
     */
    ApiResult<Long> addInit(SysTenantDO tenantDO, TenantIsolateStrategy isolateStrategy, String appCode);

    /**
     * 新增因无服务提供者而失败的记录
     *
     * @param tenantId        租户信息
     * @param isolateStrategy 迁移策略
     * @param updatedApps     已成功更新的
     * @return 失败的app
     */
    ApiResult<Set<String>> updateMigrateResultForTenant(Long tenantId, TenantIsolateStrategy isolateStrategy, Set<String> updatedApps);

    /**
     * 更新迁移结果
     *
     * @param id         迁移记录ID
     * @param success    是否成功
     * @param failReason 失败原因
     * @return 迁移记录ID
     */
    ApiResult<Long> updateResult(Long id, boolean success, String failReason);

    /**
     * 开始创建租户数据库
     *
     * @param tenantId 租户ID
     * @return 租户ID
     */
    ApiResult<Long> createTenantDb(Long tenantId);

    /**
     * 重新执行
     *
     * @param id 记录ID
     * @return 记录ID
     */
    ApiResult<Long> retry(Long id);

    /**
     * 删除租户的数据库
     *
     * @param tenantId 租户ID
     * @return 租户ID
     */
    ApiResult<Long> deleteTenantDb(Long tenantId);

    /**
     * 查询租户的创建记录
     *
     * @param tenantId 租户ID
     * @return 创建记录
     */
    ApiResult<List<SysTenantDbMigrateVO>> queryByTenant(Long tenantId);

    /**
     * 获取指定应用的迁移记录ID
     *
     * @param tenantId 租户ID
     * @param appCode  应用编码
     * @return 迁移记录ID
     */
    ApiResult<Long> getMigrateId(Long tenantId, String appCode);
}
