package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.model.vo.TestDemoVO;
import com.elitescloud.cloudt.tenant.model.vo.params.TestDemoSaveVO;

import java.util.List;

/**
 * 租户测试服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
public interface TestDemoService {

    /**
     * 新增用户
     *
     * @param saveVO 用户
     * @return 用户ID
     */
    ApiResult<Long> save(TestDemoSaveVO saveVO);

    /**
     * 保存
     *
     * @param username 用户名
     * @param id ID
     * @return ID
     */
    ApiResult<Long> upsert(String username, Long id);

    /**
     * 查询所有数据
     *
     * @return 数据列表
     */
    ApiResult<List<TestDemoVO>> queryAll();

    void test();
}
