package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.convert.TestDemoConvert;
import com.elitescloud.cloudt.tenant.model.entity.TestDemoDO;
import com.elitescloud.cloudt.tenant.model.vo.TestDemoVO;
import com.elitescloud.cloudt.tenant.model.vo.params.TestDemoSaveVO;
import com.elitescloud.cloudt.tenant.service.TestDemoService;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepo;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
@Service
public class TestDemoServiceImpl implements TestDemoService {

    private static final TestDemoConvert CONVERT = TestDemoConvert.INSTANCE;

    @Autowired
    private TestDemoRepo testDemoRepo;
    @Autowired
    private TestDemoRepoProc testDemoRepoProc;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> save(TestDemoSaveVO saveVO) {
        if (CharSequenceUtil.isBlank(saveVO.getUsername())) {
            return ApiResult.fail("用户名为空");
        }

        boolean exits = testDemoRepoProc.existsUsername(saveVO.getUsername(), saveVO.getId());
        if (exits) {
            return ApiResult.fail("用户名已存在");
        }

        TestDemoDO demoDO = CONVERT.saveVo2Do(saveVO);
        demoDO.setJoinTime(LocalDateTime.now());
        demoDO.setAge(2);
        testDemoRepoProc.save(demoDO);

        return ApiResult.ok(demoDO.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> upsert(String username, Long id) {
        id = testDemoRepoProc.upsert(username, id);
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<List<TestDemoVO>> queryAll() {
        var dos = testDemoRepo.findAll();

        var result = CONVERT.do2Vo(dos);
        return ApiResult.ok(result);
    }

    @Async
    @Override
    public void test() {
        System.out.println(TenantClient.getCurrentTenant());
    }
}
