package com.elitescloud.cloudt.tenant.provider.callback;

import com.elitescloud.cloudt.system.service.callback.TenantChangedCallback;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 租户删除后的回调.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/24
 */
@Component
public class TenantDeletedCallback implements TenantChangedCallback {

    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;
    @Autowired
    private SysTenantUserRepoProc tenantUserRepoProc;

    @Override
    public void onDelete(long id, boolean real) {
        if (real) {
            // 租户绑定的APP
            tenantAppRepoProc.deleteByTenant(id);
            // 租户绑定的用户
            tenantUserRepoProc.deleteByTenant(id);
        }
    }
}
