package com.elitescloud.cloudt.tenant.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/4/24
 */
@Data
@ApiModel(description = "租户信息")
public class ApiTenantVO implements Serializable {
    private static final long serialVersionUID = 8159937357908487553L;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long id;

    /**
     * 租户编码
     */
    @ApiModelProperty(value = "租户编码")
    private String tenantCode;

    /**
     * 租户名称
     */
    @ApiModelProperty(value = "租户名称")
    private String tenantName;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人")
    private String linkman;

    /**
     * 联系地址
     */
    @ApiModelProperty(value = "联系地址")
    private String address;

    /**
     * 域名地址，二级域名部分
     */
    @ApiModelProperty(value = "域名地址，二级域名部分")
    private String tenantDomain;

    /**
     * 租户自己的域名
     */
    @ApiModelProperty(value = "租户自己的域名")
    private String customDomain;

}
