package com.elitescloud.cloudt.tenant.service.manager;

import com.elitescloud.boot.tenant.client.common.TenantDatabaseRpcProvider;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/8/1
 */
public interface TenantClientCaller {

    /**
     * 所有应用编码
     *
     * @return 应用编码
     */
    @Nullable
    Set<String> allAppCodes();

    /**
     * 调用客户端接口
     *
     * @param appCode         应用编码
     * @param timeout         超时时间
     * @param rpcProviderCall 回调方法
     * @return 执行结果
     */
    boolean callDatabaseRpcProvider(@NonNull String appCode, Integer timeout, @NonNull Predicate<TenantDatabaseRpcProvider> rpcProviderCall);

    /**
     * 直接走本地的服务
     *
     * @return
     */
    default Set<String> directLocalServices() {
        return Collections.emptySet();
    }
}
