package com.elitescloud.cloudt.tenant.controller.api;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.tenant.model.vo.ApiTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.ApiTenantQueryParamVO;
import com.elitescloud.cloudt.tenant.service.ApiTenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 租户API接口.
 *
 * @author Kaiser（wang shao）
 * 2022/4/24
 */
@ResponseBody
@RequestMapping(value = "/api/tenant", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "租户API", tags = "API接口")
public class ApiTenantController {

    @Autowired
    private ApiTenantService tenantService;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    /**
     * 获取所有租户
     *
     * @return
     */
    @ApiOperation(value = "获取所有租户信息")
    @GetMapping(value = "/all")
    public ApiResult<List<ApiTenantVO>> queryAll() {
        return tenantService.queryAll();
    }

    /**
     * 分页查询租户信息
     *
     * @param queryParamVO 查询参数
     * @return
     */
    @ApiOperation(value = "分页查询租户信息")
    @PostMapping(value = "/query")
    public ApiResult<PagingVO<ApiTenantVO>> query(@RequestBody ApiTenantQueryParamVO queryParamVO) {
        return tenantService.query(queryParamVO);
    }

    /**
     * 获取单个租户
     *
     * @return
     */
    @ApiOperation(value = "获取单个租户")
    @GetMapping(value = "/one")
    public ApiResult<Object> getOne(@RequestParam(name = "id", required = false) Long id,
                                                   @RequestParam(name = "code", required = false) String code) {
        if (id != null) {
            return ApiResult.ok(tenantClientProvider.getTenant(id));
        }
        if (StringUtils.hasText(code)) {
            return ApiResult.ok(tenantClientProvider.getTenantByCode(code));
        }
        return ApiResult.ok(tenantClientProvider.getAllTenants());
    }
}
