/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.controller.api;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.tenant.model.vo.ApiTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.ApiTenantQueryParamVO;
import com.elitescloud.cloudt.tenant.service.ApiTenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/api/tenant"}, produces={"application/json"})
@Api(value="\u79df\u6237API", tags={"API\u63a5\u53e3"})
public class ApiTenantController {
    @Autowired
    private ApiTenantService tenantService;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u79df\u6237\u4fe1\u606f")
    @GetMapping(value={"/all"})
    public ApiResult<List<ApiTenantVO>> queryAll() {
        return this.tenantService.queryAll();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u79df\u6237\u4fe1\u606f")
    @PostMapping(value={"/query"})
    public ApiResult<PagingVO<ApiTenantVO>> query(@RequestBody ApiTenantQueryParamVO queryParamVO) {
        return this.tenantService.query(queryParamVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u79df\u6237")
    @GetMapping(value={"/one"})
    public ApiResult<Object> getOne(@RequestParam(name="id", required=false) Long id, @RequestParam(name="code", required=false) String code) {
        if (id != null) {
            return ApiResult.ok((Object)this.tenantClientProvider.getTenant(id));
        }
        if (StringUtils.hasText((String)code)) {
            return ApiResult.ok((Object)this.tenantClientProvider.getTenantByCode(code));
        }
        return ApiResult.ok((Object)this.tenantClientProvider.getAllTenants());
    }
}

