package com.elitescloud.cloudt.tenant.model.vo;

import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 平台租户
 *
 * @author roman.zhang
 * @since 2022-02-16 15:16:02
 */

@Data
@ApiModel(description = "平台租户")
public class SysTenantVO implements Serializable {
    private static final long serialVersionUID = -40112505167794113L;
    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID", position = 1)
    private Long id;

    /**
     * 租户编码
     */
    @ApiModelProperty(value = "租户编码", position = 2)
    private String tenantCode;

    /**
     * 租户名称
     */
    @ApiModelProperty(value = "租户名称", position = 3)
    private String tenantName;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 4)
    private Boolean enabled;

    /**
     * 管理员登录账号
     */
    @ApiModelProperty(value = "管理员账号", position = 11)
    private String adminAccount;

    /**
     * 管理员登录账号
     */
    @ApiModelProperty(value = "管理员账号ID", position = 11)
    private Long adminUserId;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人", position = 12)
    private String linkman;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话", position = 13)
    private String contactNumber;

    /**
     * 联系地址
     */
    @ApiModelProperty(value = "联系地址", position = 14)
    private String address;

    /**
     * 租户数据隔离策略，目前仅支持SCHEMA
     */
    @ApiModelProperty(value = "租户数据隔离策略，目前仅支持SCHEMA", position = 21, hidden = true)
    @JsonIgnore()
    private String tenantIsolation;

    @ApiModelProperty(value = "数据库是否已初始化", position = 21)
    private Boolean dbInitialized;

    /**
     * schema名称，支持英文字母、数字和下划线
     */
    @ApiModelProperty(value = "schema名称，支持英文字母、数字和下划线", position = 24)
    private String schemaName;

    /**
     * 域名地址
     */
    @ApiModelProperty(value = "域名地址", position = 31)
    private String tenantDomain;

    /**
     * 租户自定义域名
     */
    @ApiModelProperty(value = "租户自定义域名", position = 32)
    private String customDomain;

    @ApiModelProperty(value = "分配的租户应用", position = 32)
    private Set<String> appCodes;

    @ApiModelProperty(value = "租户应用列表", position = 32)
    private List<IdCodeNameCheckParam> appCodeList;

    /**
     * 所属行业，[UDC]COM:INDUSTRY
     */
    @ApiModelProperty(value = "所属行业，[UDC]COM:INDUSTRY", position = 33)
    private String industry;

    /**
     * 所属行业
     */
    @ApiModelProperty(value = "所属行业", position = 33)
    private String industryName;

    /**
     * 所属客户，[UDC]SYS:CUSTOMER
     */
    @ApiModelProperty(value = "所属客户，[UDC]SYS:CUSTOMER", position = 34)
    private String customer;

    /**
     * 所属客户
     */
    @ApiModelProperty(value = "所属客户", position = 34)
    private String customerName;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 41)
    private String remark;

    /**
     * 记录创建时间
     */
    @ApiModelProperty(value = "记录创建时间", position = 42)
    private LocalDateTime createTime;

    /**
     * 记录创建人
     */
    @ApiModelProperty(value = "记录创建人", position = 42)
    private String creator;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty(value = "记录最后更新时间", position = 43)
    private LocalDateTime modifyTime;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty(value = "记录最后更新者", position = 43)
    private String updater;
}
