package com.elitescloud.cloudt.tenant.model.vo.params;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Set;

/**
 * 平台租户
 *
 * @author roman.zhang
 * @since 2022-02-16 15:16:04
 */

@Data
@ApiModel(description = "平台租户")
public class SysTenantCreateParam implements Serializable {
    private static final long serialVersionUID = -20798209511044625L;

    /**
     * 租户编码
     */
    @ApiModelProperty(value = "租户编码", required = true, position = 1)
    @NotBlank(message = "租户编码不能为空")
    private String tenantCode;

    /**
     * 租户名称
     */
    @ApiModelProperty(value = "租户名称", required = true, position = 2)
    @NotBlank(message = "租户名称不能为空")
    private String tenantName;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 3)
    private Boolean enabled;

    /**
     * 管理员登录账号
     */
    @ApiModelProperty(value = "管理员账号，设置后不可修改", required = true, position = 4)
    @NotBlank(message = "管理员账号不能为空")
    private String adminAccount;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人", position = 11)
    private String linkman;

    /**
     * 联系人手机号
     */
    @ApiModelProperty(value = "联系人手机号", position = 12)
    private String contactNumber;
    /**
     * 联系地址
     */
    @ApiModelProperty(value = "联系地址", position = 13)
    private String address;

    /**
     * 数据隔离策略
     * DATABASE：数据库，SCHEMA：schema, FIELD：字段
     */
    @ApiModelProperty(value = "租户数据隔离，DATABASE：数据库，SCHEMA：schema, FIELD：字段", position = 21, hidden = true)
//    @NotBlank(message = "租户数据隔离策略不能为空")
    private String tenantIsolation;

    /**
     * 租户数据隔离：DATABASE：数据库，SCHEMA：schema, FIELD：字段
     */
    @ApiModelProperty(value = "schema名称，小写字母和下划线，设置后不可修改，数据分离策略是SCHEMA时必填", position = 23)
    private String schemaName;

    /**
     * 域名地址
     */
    @ApiModelProperty(value = "域名地址，空时系统自动生成", position = 31)
    private String tenantDomain;

    /**
     * 租户自定义域名地址
     */
    @ApiModelProperty(value = "租户自定义域名，如elitesland.com", position = 32)
    private String customDomain;

    /**
     * 分配的租户应用
     */
    @ApiModelProperty(value = "分配的租户应用", position = 32)
    private Set<String> appCodes;

    /**
     * 所属行业，[UDC]cloudt-system:INDUSTRY
     */
    @ApiModelProperty(value = "所属行业，[UDC]cloudt-system:INDUSTRY", position = 33)
    private String industry;

    /**
     * 所属客户，[UDC]cloudt-system:CUSTOMER
     */
    @ApiModelProperty(value = "所属客户，[UDC]cloudt-system:CUSTOMER", position = 34)
    private String customer;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 41)
    private String remark;
}
